package editor;

import game.CustomImageDataII;
import game.PlayingWithCosine;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.Transparency;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class NewHurtzoneWizard extends JPanel implements Runnable {
	
	private JTextArea betweenFirings;
	private JTextArea duration;
	private JTextArea warnTime;
	private JTextArea damage;
	private JTextArea fireChanceNumerator;
	private JTextArea fireChanceDenominator;
	
	private int betweenFiringsInt;
	private int durationInt;
	private int warnTimeInt;
	private int damageInt;
	private int fireChanceNumeratorInt;
	private int fireChanceDenominatorInt;
	
	
	private JDialog frame;
	
	private JPanel topPanel;
	
	private BufferedImage graphImage;
	private CustomImageDataII minImage;
	private CustomImageDataII maxImage;
	
	private int minColorPre;
	private int maxColorPre;
	
	private boolean userIsManipulatingMin = false;
	private boolean userIsManipulatingMax = false;
	
	private JRadioButton isHorizontal;
	private JRadioButton isVertical;
	
	private boolean wasCancelled = true;
	
	public NewHurtzoneWizard(JDialog theFrame) {
		
		wasCancelled = true;
		frame = theFrame;
		
		try {
			minImage = new CustomImageDataII("/images/minColorMarker.GIF", Color.green, this);
			maxImage = new CustomImageDataII("/images/maxColorMarker.GIF", Color.green, this);
		} catch(Exception e) {
//			e.printStackTrace();
		}
		
		minColorPre = 60;
		maxColorPre = 100;
		
		this.setLayout(new BorderLayout());
		
		JPanel buttonsPanel = new JPanel(new GridLayout(1, 4));
		
		JButton cancelButton = new JButton("Cancel");
		cancelButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				frame.dispose();
			}
		});
		buttonsPanel.add(cancelButton);
		
		buttonsPanel.add(new JPanel());
		buttonsPanel.add(new JPanel());
		
		JButton okButton = new JButton("OK");
		okButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				okWasClicked();
			}
		});
		buttonsPanel.add(okButton);
		
		this.add(buttonsPanel, BorderLayout.SOUTH);
		
		
		
		JPanel mainPanel = new JPanel();
		
		mainPanel.setLayout(new GridLayout(4, 2));
		
		JPanel betweenFiringsPanel = new JPanel(new FlowLayout());
		betweenFiringsPanel.add(new JLabel("<html>millis between firings:<br/>(use 0 for constantly)</html>"));
		betweenFirings = new JTextArea();
		betweenFirings.setMinimumSize(new Dimension(50, 20));
		betweenFirings.setMaximumSize(new Dimension(50, 20));
		betweenFirings.setPreferredSize(new Dimension(50, 20));
		betweenFirings.setBorder(BorderFactory.createLoweredBevelBorder());
		betweenFiringsPanel.add(betweenFirings);
		mainPanel.add(betweenFiringsPanel);
		
		JPanel durationPanel = new JPanel(new FlowLayout());
		durationPanel.add(new JLabel("duration in millis:"));
		duration = new JTextArea();
		duration.setMinimumSize(new Dimension(50, 20));
		duration.setMaximumSize(new Dimension(50, 20));
		duration.setPreferredSize(new Dimension(50, 20));
		duration.setBorder(BorderFactory.createLoweredBevelBorder());
		durationPanel.add(duration);
		mainPanel.add(durationPanel);
		
		
		JPanel warnTimePanel = new JPanel(new FlowLayout());
		warnTimePanel.add(new JLabel("warn time in millis:"));
		warnTime = new JTextArea();
		warnTime.setMinimumSize(new Dimension(50, 20));
		warnTime.setMaximumSize(new Dimension(50, 20));
		warnTime.setPreferredSize(new Dimension(50, 20));
		warnTime.setBorder(BorderFactory.createLoweredBevelBorder());
		warnTimePanel.add(warnTime);
		mainPanel.add(warnTimePanel);
		
		
		JPanel damagePanel = new JPanel(new FlowLayout());
		damagePanel.add(new JLabel("damage:"));
		damage = new JTextArea();
		damage.setMinimumSize(new Dimension(50, 20));
		damage.setMaximumSize(new Dimension(50, 20));
		damage.setPreferredSize(new Dimension(50, 20));
		damage.setBorder(BorderFactory.createLoweredBevelBorder());
		damagePanel.add(damage);
		mainPanel.add(damagePanel);
		
		
		JPanel fireChanceNumeratorPanel = new JPanel(new FlowLayout());
		fireChanceNumeratorPanel.add(new JLabel("fireChanceNumerator:"));
		fireChanceNumerator = new JTextArea();
		fireChanceNumerator.setMinimumSize(new Dimension(50, 20));
		fireChanceNumerator.setMaximumSize(new Dimension(50, 20));
		fireChanceNumerator.setPreferredSize(new Dimension(50, 20));
		fireChanceNumerator.setBorder(BorderFactory.createLoweredBevelBorder());
		fireChanceNumeratorPanel.add(fireChanceNumerator);
		mainPanel.add(fireChanceNumeratorPanel);
		
		
		JPanel fireChanceDenominatorPanel = new JPanel(new FlowLayout());
		fireChanceDenominatorPanel.add(new JLabel("fireChanceDenominator:"));
		fireChanceDenominator = new JTextArea();
		fireChanceDenominator.setMinimumSize(new Dimension(50, 20));
		fireChanceDenominator.setMaximumSize(new Dimension(50, 20));
		fireChanceDenominator.setPreferredSize(new Dimension(50, 20));
		fireChanceDenominator.setBorder(BorderFactory.createLoweredBevelBorder());
		fireChanceDenominatorPanel.add(fireChanceDenominator);
		mainPanel.add(fireChanceDenominatorPanel);
		
		
		ButtonGroup horVerGroup = new ButtonGroup();
		isHorizontal = new JRadioButton("Hurtzone is Horizontal?");
		horVerGroup.add(isHorizontal);
		JPanel isHorizontalPanel= new JPanel(new FlowLayout());
		isHorizontalPanel.add(isHorizontal);
		mainPanel.add(isHorizontalPanel);
		
		isVertical = new JRadioButton("Hortzone is Vertical?");
		JPanel isVerticalPanel = new JPanel(new FlowLayout());
		horVerGroup.add(isVertical);
		isVerticalPanel.add(isVertical);
		mainPanel.add(isVerticalPanel);
		
		
		this.add(mainPanel, BorderLayout.CENTER);
		
		
		topPanel = new JPanel() {
			public void paintComponent(Graphics g) {
				if(graphImage == null) {
					GraphicsConfiguration gc = CustomImageDataII.getGC();
					graphImage = gc.createCompatibleImage(500, 100, Transparency.TRANSLUCENT);
					
					Graphics gg = graphImage.getGraphics();
					
					Color origCol = gg.getColor();
					
					gg.setColor(Color.WHITE);
					gg.fillRect(0, 0, 500, 75);
					
					double tempScalar;
					Color tempColor;
					
					for(int i = 50; i < 450; i++) {
						tempScalar = ((i-50) / 400.0);
						tempColor = PlayingWithCosine.scalarToColor(tempScalar);
						gg.setColor(tempColor);
						gg.drawLine(i, 10, i, 30);
					}
					
					gg.setColor(origCol);
					
					gg.dispose();
					
				}
				
				
				g.drawImage(graphImage, 0, 0, this);
				

				minImage.drawObjectFromUpperLeftCorner(g, minColorPre + 50 - 37, 28);
				
				maxImage.drawObjectFromUpperLeftCorner(g, maxColorPre + 50, 28);
				
				
				
			}
		};
		topPanel.setMaximumSize(new Dimension(500, 75));
		topPanel.setMinimumSize(new Dimension(500, 75));
		topPanel.setPreferredSize(new Dimension(500, 75));
		
		this.add(topPanel, BorderLayout.NORTH);
		
		Thread thread = new Thread(this);
		thread.start();
		
		
		this.addMouseListener(new MouseListener() {
			
			@Override
			public void mouseReleased(MouseEvent arg0) {
				onMouseUp(arg0);
			}
			
			@Override
			public void mousePressed(MouseEvent arg0) {
				onMouseDown(arg0);
			}
			
			@Override
			public void mouseExited(MouseEvent arg0) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void mouseEntered(MouseEvent arg0) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void mouseClicked(MouseEvent arg0) {
				// TODO Auto-generated method stub
				
			}
		});
		
		this.addMouseMotionListener(new MouseMotionListener() {
			
			@Override
			public void mouseMoved(MouseEvent arg0) {
				//onMouseMove(arg0);
			}
			
			@Override
			public void mouseDragged(MouseEvent arg0) {
				onMouseMove(arg0);
			}
		});
		
		
		this.setMinimumSize(new Dimension(500, 400));
		this.setMaximumSize(new Dimension(500, 400));
		this.setPreferredSize(new Dimension(500, 400));
		
//		System.out.println("<><>DELME got to the end of the wizard constructor");
		
	}
	
	
	public static void main(String [] args) {
		
		JDialog frame = new JDialog();
		
		NewHurtzoneWizard w = new NewHurtzoneWizard(frame);
		frame.setContentPane(w);
		
		frame.setMinimumSize(new Dimension(500, 400));
		frame.setMaximumSize(new Dimension(500, 400));
		frame.setPreferredSize(new Dimension(500, 400));
		
		frame.setVisible(true);
		
	}
	

	@Override
	public void run() {
		
		int tryCount = 0;
		
		while(!frame.isVisible()) {
			try { 
				Thread.sleep(100L); 
			}catch(Throwable t) {
//				t.printStackTrace();
				break;
			}
			tryCount++;
			if(tryCount > 3)
				break;
		}
		
//		System.out.println("<><>DELME got to the end of the waiting bit...");
		
		while(frame.isVisible()) {
			try { 
				Thread.sleep(50L); 
			}catch(Throwable t) {
//				t.printStackTrace();
				break;
			}
			topPanel.repaint();
//			System.out.println("<><>DELME repainted!  min: " + minColorPre);
		}

//		System.out.println("<><>DELME got to the end of the whole run method...");
		
	}
	
	
	public void onMouseDown(MouseEvent e) {
		

		//System.out.println("<><>DELME now in mousedown!");
		
		if(e.getY() > 75)
			return;
		
		if(e.getX() < (this.minColorPre + 50) && e.getX() > (this.minColorPre - 38 + 50)) {
			userIsManipulatingMin = true;
		} else if(e.getX() > (this.maxColorPre + 50) && e.getX() < (this.maxColorPre + 38 + 50) ) {
			userIsManipulatingMax = true;
		}
		
			
	}
	
	public void onMouseUp(MouseEvent e) {

//		System.out.println("<><>DELME now in mouseup!");
		
		userIsManipulatingMax = false;
		userIsManipulatingMin = false;
	}
	
	
	public void onMouseMove(MouseEvent e) {
		
		//System.out.println("<><>DELME now in mousemove!  min: " + userIsManipulatingMin + ", max: " + userIsManipulatingMax);
		
		if(userIsManipulatingMax) {
			this.maxColorPre = e.getX() -50;
			if(this.maxColorPre > 399)
				this.maxColorPre = 399;
			if(this.maxColorPre < this.minColorPre)
				this.maxColorPre = this.minColorPre;
		}
		
		if(userIsManipulatingMin) {
			this.minColorPre = e.getX() - 50;
			if(this.minColorPre < 0)
				this.minColorPre = 0;
			if(this.minColorPre > this.maxColorPre)
				this.minColorPre = this.maxColorPre;
		}
		
		
	}
	
	
	
	private void okWasClicked() {
		
//		private JTextArea betweenFirings;
//		private JTextArea duration;
//		private JTextArea warnTime;
//		private JTextArea damage;
//		private JTextArea fireChanceNumerator;
//		private JTextArea fireChanceDenominator;
		
//		private JRadioButton isHorizontal;
//		private JRadioButton isVertical;	
		
		StringBuffer sb = new StringBuffer("<html>Cannot create a hurtzone with these inputs:<br><br>");
		boolean errorOccurred = false;
		
		
		
		
		if(betweenFirings.getText() == null || betweenFirings.getText().length() == 0) {
			errorOccurred = true;
			sb.append("You didn't enter anything for \"millis between firings\"<br>");
		} else {
			try {
				betweenFiringsInt = Integer.parseInt(betweenFirings.getText().trim());
			} catch(NumberFormatException e) {
				errorOccurred = true;
				sb.append("You didn't enter a number for \"millis between firings\"<br>");
			}
		}
		
		if(duration.getText() == null || duration.getText().length() == 0) {
			errorOccurred = true;
			sb.append("You didn't enter anything for \"duration in millis\"<br>");
		} else {
			try {
				durationInt = Integer.parseInt(duration.getText().trim());
			} catch(NumberFormatException e) {
				errorOccurred = true;
				sb.append("You didn't enter a number for \"duration in millis\"<br>");
			}
		}
		
		if(warnTime.getText() == null || warnTime.getText().length() == 0) {
			errorOccurred = true;
			sb.append("You didn't enter anything for \"warnTime in millis\"<br>");
		} else {
			try {
				warnTimeInt = Integer.parseInt(warnTime.getText().trim());
			} catch(NumberFormatException e) {
				errorOccurred = true;
				sb.append("You didn't enter a number for \"warnTime in millis\"<br>");
			}
		}
		
		if(damage.getText() == null || damage.getText().length() == 0) {
			errorOccurred = true;
			sb.append("You didn't enter anything for \"damage\"<br>");
		} else {
			try {
				damageInt = Integer.parseInt(damage.getText().trim());
				if(damageInt < 0) {
					errorOccurred = true;
					sb.append("You can't enter a negative number for \"damage\"<br>");
				}
			} catch(NumberFormatException e) {
				errorOccurred = true;
				sb.append("You didn't enter a number for \"damage\"<br>");
			}
		}
		
		if(fireChanceNumerator.getText() == null || fireChanceNumerator.getText().length() == 0) {
			errorOccurred = true;
			sb.append("You didn't enter anything for \"fireChangeNumerator\"<br>");
		} else {
			try {
				fireChanceNumeratorInt = Integer.parseInt(fireChanceNumerator.getText().trim());
			} catch(NumberFormatException e) {
				errorOccurred = true;
				sb.append("You didn't enter a number for \"fireChangeNumerator\"<br>");
			}
		}
		
		if(fireChanceDenominator.getText() == null || fireChanceDenominator.getText().length() == 0) {
			errorOccurred = true;
			sb.append("You didn't enter anything for \"fireChangeDenominator\"<br>");
		} else {
			try {
				fireChanceDenominatorInt = Integer.parseInt(fireChanceDenominator.getText().trim());
				if(fireChanceDenominatorInt == 0) {
					errorOccurred = true;
					sb.append("Ha ha.  Very funny.  \"fireChangeDenominator\" can't be 0.<br>");
				}
			} catch(NumberFormatException e) {
				errorOccurred = true;
				sb.append("You didn't enter a number for \"fireChangeDenominator\"<br>");
			}
			
			
		}
		
		
		
		if(!isHorizontal.isSelected() && !isVertical.isSelected()) {
			errorOccurred = true;
			sb.append("You must select either vertical or horizontal<br>");
		}
		
		
		if(errorOccurred) {
			
			sb.append("<br>You must correct these before you can create a hurtzone palette object.</html>");
			
			JOptionPane.showMessageDialog(this, sb.toString(), "Unable to create Hurtzone Palette Object", JOptionPane.WARNING_MESSAGE);
			
			return;
			
		}
		
		
		wasCancelled = false;
		
		frame.dispose();
	}
	
	
	public boolean wasCancelled() {
		return wasCancelled;
	}
	
	
	public int getDamage() {
		return damageInt;
	}
	
	public int getMinimumTimeBetweenFirings() {
		return betweenFiringsInt;
	}
	
	public int getDuration() {
		return durationInt;
	}
	
	public int getWarmupTime() {
		return warnTimeInt;
	}
	
	public int getFireChanceNumerator() {
		return fireChanceNumeratorInt;
	}
	
	public int getFireChanceDenominator() {
		return fireChanceDenominatorInt;
	}
	
	public boolean isVertical() {
		if(isHorizontal.isSelected())
			return false;
		else
			return true;
	}
	
	public double getMinColor() {
		return minColorPre / 400.0;
	}
	
	public double getMaxColor() {
		return maxColorPre / 400.0;
	}
	
	
	
	

	public NewHurtzoneWizard(JDialog theFrame,
							 int theTimeBetweenFirings,
							 int theDurationInMillis,
							 int theWarnTime,
							 int theDamage,
							 int theFireNumerator,
							 int theFireDenominator,
							 double theMinColor,
							 double theMaxColor,
							 boolean shouldBeVertical) {
		
		wasCancelled = true;
		frame = theFrame;
		
		try {
			minImage = new CustomImageDataII("/images/minColorMarker.GIF", Color.green, this);
			maxImage = new CustomImageDataII("/images/maxColorMarker.GIF", Color.green, this);
		} catch(Exception e) {
//			e.printStackTrace();
		}
		
		minColorPre = (int) Math.round(theMinColor * 400);
		maxColorPre = (int) Math.round(theMaxColor * 400);
		
		this.setLayout(new BorderLayout());
		
		JPanel buttonsPanel = new JPanel(new GridLayout(1, 4));
		
		JButton cancelButton = new JButton("Cancel");
		cancelButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				frame.dispose();
			}
		});
		buttonsPanel.add(cancelButton);
		
		buttonsPanel.add(new JPanel());
		buttonsPanel.add(new JPanel());
		
		JButton okButton = new JButton("OK");
		okButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				okWasClicked();
			}
		});
		buttonsPanel.add(okButton);
		
		this.add(buttonsPanel, BorderLayout.SOUTH);
		
		
		
		JPanel mainPanel = new JPanel();
		
		mainPanel.setLayout(new GridLayout(4, 2));
		
		JPanel betweenFiringsPanel = new JPanel(new FlowLayout());
		betweenFiringsPanel.add(new JLabel("<html>millis between firings:<br/>(use 0 for constantly)</html>"));
		betweenFirings = new JTextArea(Integer.toString(theTimeBetweenFirings));
		betweenFirings.setMinimumSize(new Dimension(50, 20));
		betweenFirings.setMaximumSize(new Dimension(50, 20));
		betweenFirings.setPreferredSize(new Dimension(50, 20));
		betweenFirings.setBorder(BorderFactory.createLoweredBevelBorder());
		betweenFiringsPanel.add(betweenFirings);
		mainPanel.add(betweenFiringsPanel);
		
		JPanel durationPanel = new JPanel(new FlowLayout());
		durationPanel.add(new JLabel("duration in millis:"));
		duration = new JTextArea(Integer.toString(theDurationInMillis));
		duration.setMinimumSize(new Dimension(50, 20));
		duration.setMaximumSize(new Dimension(50, 20));
		duration.setPreferredSize(new Dimension(50, 20));
		duration.setBorder(BorderFactory.createLoweredBevelBorder());
		durationPanel.add(duration);
		mainPanel.add(durationPanel);
		
		
		JPanel warnTimePanel = new JPanel(new FlowLayout());
		warnTimePanel.add(new JLabel("warn time in millis:"));
		warnTime = new JTextArea(Integer.toString(theWarnTime));
		warnTime.setMinimumSize(new Dimension(50, 20));
		warnTime.setMaximumSize(new Dimension(50, 20));
		warnTime.setPreferredSize(new Dimension(50, 20));
		warnTime.setBorder(BorderFactory.createLoweredBevelBorder());
		warnTimePanel.add(warnTime);
		mainPanel.add(warnTimePanel);
		
		
		JPanel damagePanel = new JPanel(new FlowLayout());
		damagePanel.add(new JLabel("damage:"));
		damage = new JTextArea(Integer.toString(theDamage));
		damage.setMinimumSize(new Dimension(50, 20));
		damage.setMaximumSize(new Dimension(50, 20));
		damage.setPreferredSize(new Dimension(50, 20));
		damage.setBorder(BorderFactory.createLoweredBevelBorder());
		damagePanel.add(damage);
		mainPanel.add(damagePanel);
		
		
		JPanel fireChanceNumeratorPanel = new JPanel(new FlowLayout());
		fireChanceNumeratorPanel.add(new JLabel("fireChanceNumerator:"));
		fireChanceNumerator = new JTextArea(Integer.toString(theFireNumerator));
		fireChanceNumerator.setMinimumSize(new Dimension(50, 20));
		fireChanceNumerator.setMaximumSize(new Dimension(50, 20));
		fireChanceNumerator.setPreferredSize(new Dimension(50, 20));
		fireChanceNumerator.setBorder(BorderFactory.createLoweredBevelBorder());
		fireChanceNumeratorPanel.add(fireChanceNumerator);
		mainPanel.add(fireChanceNumeratorPanel);
		
		
		JPanel fireChanceDenominatorPanel = new JPanel(new FlowLayout());
		fireChanceDenominatorPanel.add(new JLabel("fireChanceDenominator:"));
		fireChanceDenominator = new JTextArea(Integer.toString(theFireDenominator));
		fireChanceDenominator.setMinimumSize(new Dimension(50, 20));
		fireChanceDenominator.setMaximumSize(new Dimension(50, 20));
		fireChanceDenominator.setPreferredSize(new Dimension(50, 20));
		fireChanceDenominator.setBorder(BorderFactory.createLoweredBevelBorder());
		fireChanceDenominatorPanel.add(fireChanceDenominator);
		mainPanel.add(fireChanceDenominatorPanel);
		
		
		ButtonGroup horVerGroup = new ButtonGroup();
		isHorizontal = new JRadioButton("Hurtzone is Horizontal?");
		isHorizontal.setEnabled(false);
		if(!shouldBeVertical)
			isHorizontal.setSelected(true);
		horVerGroup.add(isHorizontal);
		JPanel isHorizontalPanel= new JPanel(new FlowLayout());
		isHorizontalPanel.add(isHorizontal);
		mainPanel.add(isHorizontalPanel);
		
		isVertical = new JRadioButton("Hortzone is Vertical?");
		isVertical.setEnabled(false);
		if(shouldBeVertical)
			isVertical.setSelected(true);
		JPanel isVerticalPanel = new JPanel(new FlowLayout());
		horVerGroup.add(isVertical);
		isVerticalPanel.add(isVertical);
		mainPanel.add(isVerticalPanel);
		
		
		this.add(mainPanel, BorderLayout.CENTER);
		
		
		topPanel = new JPanel() {
			public void paintComponent(Graphics g) {
				if(graphImage == null) {
					GraphicsConfiguration gc = CustomImageDataII.getGC();
					graphImage = gc.createCompatibleImage(500, 100, Transparency.TRANSLUCENT);
					
					Graphics gg = graphImage.getGraphics();
					
					Color origCol = gg.getColor();
					
					gg.setColor(Color.WHITE);
					gg.fillRect(0, 0, 500, 75);
					
					double tempScalar;
					Color tempColor;
					
					for(int i = 50; i < 450; i++) {
						tempScalar = ((i-50) / 400.0);
						tempColor = PlayingWithCosine.scalarToColor(tempScalar);
						gg.setColor(tempColor);
						gg.drawLine(i, 10, i, 30);
					}
					
					gg.setColor(origCol);
					
					gg.dispose();
					
				}
				
				
				g.drawImage(graphImage, 0, 0, this);
				

				minImage.drawObjectFromUpperLeftCorner(g, minColorPre + 50 - 37, 28);
				
				maxImage.drawObjectFromUpperLeftCorner(g, maxColorPre + 50, 28);
				
				
				
			}
		};
		topPanel.setMaximumSize(new Dimension(500, 75));
		topPanel.setMinimumSize(new Dimension(500, 75));
		topPanel.setPreferredSize(new Dimension(500, 75));
		
		this.add(topPanel, BorderLayout.NORTH);
		
		Thread thread = new Thread(this);
		thread.start();
		
		
		this.addMouseListener(new MouseListener() {
			
			@Override
			public void mouseReleased(MouseEvent arg0) {
				onMouseUp(arg0);
			}
			
			@Override
			public void mousePressed(MouseEvent arg0) {
				onMouseDown(arg0);
			}
			
			@Override
			public void mouseExited(MouseEvent arg0) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void mouseEntered(MouseEvent arg0) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void mouseClicked(MouseEvent arg0) {
				// TODO Auto-generated method stub
				
			}
		});
		
		this.addMouseMotionListener(new MouseMotionListener() {
			
			@Override
			public void mouseMoved(MouseEvent arg0) {
				//onMouseMove(arg0);
			}
			
			@Override
			public void mouseDragged(MouseEvent arg0) {
				onMouseMove(arg0);
			}
		});
		
		
		this.setMinimumSize(new Dimension(500, 400));
		this.setMaximumSize(new Dimension(500, 400));
		this.setPreferredSize(new Dimension(500, 400));
		
//		System.out.println("<><>DELME got to the end of the wizard constructor");
		
	}
	
	
	
}
